----------------------------------------------------------------------------------------------------------------------------------------------
-- Modify new trigger on Historic table to fill the HistoricResponse table for a given list of questions with reponses with RpsType = 0 only
----------------------------------------------------------------------------------------------------------------------------------------------
/****** Object:  Trigger [VX_TR_ReponseModifLog]    Script Date: 04/10/2013 10:52:08 ******/
IF  EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[VX_TR_HistoricResponse_Insert]'))
DROP TRIGGER [dbo].[VX_TR_HistoricResponse_Insert]
GO

IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[VX_TR_HistoricResponse_Insert]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[VX_TR_HistoricResponse_Insert]
   ON  [dbo].[Historic]
   AFTER INSERT
AS 
BEGIN
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON;
-- From the Installation configuration, the option for Audit of the Response table.
  INSERT INTO dbo.HistoricResponse 
     (Respondent, CallId, Question, Matrix, Mention, Content, OpenEnd, ModifiedBy, Modified)
    SELECT inserted.HisRespondent, inserted.HisCallNumber, r.RpsQuestion, r.RpsMatrix, r.RpsMention, r.RpsContent, r.RpsOpened, r.modifiedby, r.modified
    FROM inserted
    join Response r	on  r.RpsRespondent = inserted.HisRespondent
    WHERE EXISTS (SELECT 1 FROM Installation WHERE INSSECTION = ''TRACKHISTORICRESPONSE'' and INSIDENT LIKE ''QUESTION![%!]'' ESCAPE ''!'' and INSVALUE = r.RpsQuestion)
    AND r.RpsType = 0
    AND inserted.IsImported = 0
END
' 
GO

